/**********************************************************************
*	Bastion Products Copyright 1998								*
*	All rights reserved										*
*	This source is freely distributable in an unmodified state.		*
*	Last Modified:	5/20/98									*
*	Author:			Jennifer Weston							*
***********************************************************************/

/* Set up a series of function pointers that are assigned at initialization */
/* Check to see if a given language id has an application dictionary */
int (*has_application_dictionary)(int32 inLangID);

/* Returns the user-configured default language */
int32 (*get_default_language)(void);

/* Gets an entry */
char* (*get_entry)(int32 inStringID, int32 inLangID, char* inBuffer, int32 inBuffSize);

/* Gets an entry */
void* (*get_blob)(uint32 inResType,int32 inResID, int32 inLangID, void* inBuffer, size_t inBuffLength, size_t* outBlobSize);

/* Gets the number of bytes in an entry */
int32 (*get_entry_length)(int32 inStringID, int32 inLangID);

/* Gets the maximum number of bytes in an entry for a given language */
int32 (*get_max_length)(int32 inLangID);

/* Returns a comma-delimited list of the names of the available
   languages (in the common directory) and returns the number of languages */
int32 (*get_language_list)(char** outList);

/* Gets a particular language name for language ID d */
char* (*language_name)(int32 inLangID, char* inBuffer, int32 inBuffSize);

/* Gets the language ID for a language called name */
int32 (*language_id)(char *inName);

/* Gets the raw bits for the Blithe bitmap */
size_t (*get_raw_bits)(void** theBits);
